/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import swing.CopyProtectMark;

public class EllipticalMark
implements CopyProtectMark,
Serializable {
    private String iType = "A";
    private int iCount = 5;
    private int iStroke = 3;

    public static EllipticalMark parse(Element markEle) throws Exception {
        EllipticalMark mark = new EllipticalMark();
        Element number = (Element)markEle.getFirstChild();
        Text text = (Text)number.getFirstChild();
        mark.iType = text.getData().trim();
        Element count = (Element)number.getNextSibling();
        text = (Text)count.getFirstChild();
        mark.iCount = Integer.parseInt(text.getData().trim());
        Element stroke = (Element)number.getNextSibling();
        text = (Text)stroke.getFirstChild();
        mark.iStroke = Integer.parseInt(text.getData().trim());
        return mark;
    }

    private EllipticalMark() {
    }

    @Override
    public void draw(Graphics2D g2, JPanel panel) {
        g2.setStroke(new BasicStroke(this.iStroke));
        if (this.iType.equalsIgnoreCase("a")) {
            double width = (double)panel.getSize().width * 0.95;
            double height = (double)panel.getSize().height * 0.95;
            int i = 0;
            while (i < this.iCount) {
                double left = ((double)panel.getSize().width - width) * 0.5;
                double top = ((double)panel.getSize().height - height) * 0.5;
                Ellipse2D.Double ellipse = new Ellipse2D.Double(left, top, width, height);
                g2.draw(ellipse);
                width *= 0.95;
                height *= 0.95;
                ++i;
            }
        } else {
            double width = (double)panel.getSize().width * 0.1;
            double height = (double)panel.getSize().height * 0.1;
            int i = 0;
            while (i < this.iCount) {
                double left = ((double)panel.getSize().width - width) * 0.5;
                double top = ((double)panel.getSize().height - height) * 0.5;
                Ellipse2D.Double ellipse = new Ellipse2D.Double(left, top, width, height);
                g2.draw(ellipse);
                width *= 1.4;
                height *= 1.4;
                ++i;
            }
        }
    }
}

