/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import bpv.Album;
import bpv.BpvMsgs;
import bpv.DisplayPage;
import bpv.Main;
import bpv.SelectionPanel;
import bpv.Thumbnail;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JTabbedPane;
import mlib.MAppMsg;
import mlib.MString;
import oroma.db.PicInfo;
import oroma.db.Query;
import oroma.website.WebImg;
import swing.StatusBox;
import swing.StdScrollPane;
import utilt.Utility;

class DisplayFiller
extends Thread {
    private Album iAlbum = null;
    private Query iQuery = null;
    private String iSelect = null;
    private String iOrderBy = null;
    private static final int DEFAULTROWS = 5;
    private static final int NUMPAGESLIMIT = 18;
    private static final String SEP = ", ";
    private static LinkedList<WebImg> UnselectedDisplayImgs = new LinkedList();
    private static LinkedList<WebImg> DisplayImgs = new LinkedList();
    private static TreeMap<String, Comparator<WebImg>> Comparators = new TreeMap();

    static {
        Comparators.put("By region", new WebImg.RegionComparator());
        Comparators.put("By date", new WebImg.DateComparator());
        Comparators.put("By id", new WebImg.IdComparator());
    }

    static int numDisplayImgs() {
        return DisplayImgs.size();
    }

    private static MString tokensForSelect(PicInfo picInfo) {
        MString all = new MString();
        String[] stringArray = Main.SearchFields;
        int n = Main.SearchFields.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            PicInfo.ComboField field = picInfo.comboField(name);
            all.concat(SEP + field.value());
            ++n2;
        }
        String date = picInfo.dateStr().replace('-', ',');
        all.concat(SEP + date);
        return all.toLowerCase();
    }

    private static int pageSize() {
        int numCols = Main.singleton().numCols();
        int numRows = 5;
        float numPages = 1.0f * (float)DisplayImgs.size() / (float)(5 * numCols);
        if (numPages > 18.0f) {
            numRows = (int)((0.5 + (double)(1.0f * numPages / 18.0f)) * (double)numRows);
        }
        int pageSize = numRows * numCols;
        return pageSize;
    }

    private static void addPage(int pageNum, DisplayPage page) {
        JTabbedPane panel = Main.singleton().tabsPanel();
        StdScrollPane spane = new StdScrollPane(page);
        panel.add("Page " + pageNum, spane);
        panel.validate();
        panel.repaint();
    }

    DisplayFiller(boolean reset) {
        this.setPriority(1);
        if (reset) {
            UnselectedDisplayImgs.clear();
            DisplayImgs.clear();
        }
    }

    void doAlbum(Album album, String orderBy) {
        this.iAlbum = album;
        this.iOrderBy = orderBy;
        this.iSelect = null;
        this.iQuery = null;
        this.start();
    }

    void doSearch(Query query, String orderBy) {
        this.iQuery = query;
        this.iOrderBy = orderBy;
        this.iAlbum = null;
        this.iSelect = null;
        this.start();
    }

    void doSelection(String selection, String orderBy) {
        this.iSelect = selection;
        this.iOrderBy = orderBy;
        this.iQuery = null;
        this.start();
    }

    void doOrdering(String orderBy) {
        this.iSelect = null;
        this.iOrderBy = orderBy;
        this.iQuery = null;
        this.start();
    }

    @Override
    public void run() {
        try {
            if (this.iAlbum != null) {
                MAppMsg msg = BpvMsgs.get("displaying");
                Main.singleton().logger().writeln(msg.format("Album: ", this.iAlbum.title()));
                for (WebImg img : Main.singleton().allImages()) {
                    if (!img.album().equals(this.iAlbum)) continue;
                    DisplayImgs.add(img);
                }
                this.order();
                UnselectedDisplayImgs.addAll(DisplayImgs);
                this.showPages();
            } else if (this.iQuery != null) {
                MAppMsg msg = BpvMsgs.get("displaying");
                Main.singleton().logger().writeln(msg.format("Search", ""));
                this.doSearch();
                this.order();
                UnselectedDisplayImgs.addAll(DisplayImgs);
                this.showPages();
            } else if (this.iSelect != null) {
                MAppMsg msg = BpvMsgs.get("displaying");
                Main.singleton().logger().writeln(msg.format("Selection", ""));
                this.doSelections();
                this.order();
                this.showPages();
            } else {
                MAppMsg msg = BpvMsgs.get("displaying");
                Main.singleton().logger().writeln(msg.format("Ordering", ""));
                this.order();
                this.showPages();
            }
        }
        catch (Exception xcp) {
            MAppMsg msg = BpvMsgs.get("runtime_error");
            Main.singleton().logger().writeln(msg.format("DisplayFiller", Utility.xcpMsg(xcp)));
        }
    }

    private void doSelections() {
        MString select = new MString(this.iSelect);
        select.remove('*', 999, 0);
        this.iSelect = select.toString();
        LinkedList<WebImg> selections = new LinkedList<WebImg>();
        if (this.iSelect.length() == 0 || this.iSelect.equals("*")) {
            selections.addAll(UnselectedDisplayImgs);
        } else {
            for (WebImg img : UnselectedDisplayImgs) {
                MString tags = DisplayFiller.tokensForSelect(img.picInfo());
                StringTokenizer tken = new StringTokenizer(tags.toString(), " ,");
                boolean found = false;
                while (!found && tken.hasMoreTokens()) {
                    String token = tken.nextToken();
                    found = token.equalsIgnoreCase(this.iSelect);
                    if (!found) continue;
                    selections.add(img);
                }
            }
        }
        DisplayImgs.clear();
        DisplayImgs.addAll(selections);
    }

    private void doSearch() {
        for (WebImg img : Main.singleton().allImages()) {
            PicInfo imgInfo = img.picInfo();
            if (!this.iQuery.matches(imgInfo)) continue;
            DisplayImgs.add(img);
        }
    }

    private void showPages() {
        if (DisplayImgs.size() == 0) {
            MAppMsg msg = BpvMsgs.get("no_photos");
            StatusBox.singleton().showMsg(msg.format(), msg.isError());
        } else {
            Main.singleton().tabsPanel().removeAll();
            WebImg[] imgs = new WebImg[DisplayImgs.size()];
            int i = 0;
            for (WebImg img : DisplayImgs) {
                imgs[i++] = img;
            }
            int pageSize = DisplayFiller.pageSize();
            int numPages = (int)Math.ceil((double)DisplayImgs.size() / (double)pageSize);
            if (numPages < 1) {
                numPages = 1;
            }
            MAppMsg msg = BpvMsgs.get("displaying_photos");
            StatusBox.singleton().queueShowMsg(msg.format(DisplayImgs.size(), numPages), msg.isError());
            Thumbnail prevThumb = null;
            int pageNum = 1;
            while (pageNum <= numPages) {
                int firstPic = (pageNum - 1) * pageSize;
                int lastPic = firstPic + pageSize - 1;
                if (lastPic >= DisplayImgs.size()) {
                    lastPic = DisplayImgs.size() - 1;
                }
                DisplayPage page = new DisplayPage(this.iAlbum, imgs);
                prevThumb = page.fill(firstPic, lastPic, prevThumb);
                DisplayFiller.addPage(pageNum, page);
                ++pageNum;
            }
            SelectionPanel.singleton().enableControls(true);
        }
    }

    private void order() {
        Comparator<WebImg> compare = Comparators.get(this.iOrderBy);
        TreeSet<WebImg> ordered = new TreeSet<WebImg>(compare);
        for (WebImg img : DisplayImgs) {
            ordered.add(img);
        }
        DisplayImgs.clear();
        for (WebImg img : ordered) {
            DisplayImgs.add(img);
        }
    }
}

