/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import bpv.EllipticalMark;
import bpv.LabelMark;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import oroma.db.Query;
import swing.CopyProtectMark;

public class AlbumGroup
implements Serializable {
    private String iName = "";
    private long iDate = 0L;
    private double iMaxViewFactor = 0.75;
    private int iMaxViewPixels = 1000;
    private String iCopyrightMsg = "";
    private CopyProtectMark iMark = LabelMark.defaultMark();
    private LinkedList<ViewerAlbum> iAlbums = new LinkedList();
    private transient String iDbPath = null;
    private transient String iServerRoot = null;
    static final long serialVersionUID = 5557291299739977703L;

    public static AlbumGroup parse(File xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new SAXErrorHandler());
        Document document = builder.parse(xml);
        Element root = document.getDocumentElement();
        AlbumGroup group = AlbumGroup.parseGroup(root);
        return group;
    }

    private static AlbumGroup parseGroup(Element listEle) throws Exception {
        AlbumGroup list = new AlbumGroup();
        Element name = (Element)listEle.getFirstChild();
        Text text = (Text)name.getFirstChild();
        list.iName = text.getData().trim();
        Element dbpath = (Element)name.getNextSibling();
        text = (Text)dbpath.getFirstChild();
        list.iDbPath = text.getData().trim();
        Element serverRoot = (Element)dbpath.getNextSibling();
        text = (Text)serverRoot.getFirstChild();
        list.iServerRoot = text.getData().trim();
        Element sibling = (Element)serverRoot.getNextSibling();
        while (sibling != null) {
            if (sibling.getTagName().equals("maxViewFactor")) {
                text = (Text)sibling.getFirstChild();
                list.iMaxViewFactor = Double.parseDouble(text.getData().trim());
            } else if (sibling.getTagName().equals("maxViewPixels")) {
                text = (Text)sibling.getFirstChild();
                list.iMaxViewPixels = Integer.parseInt(text.getData().trim());
            } else if (sibling.getTagName().equals("copyrightMsg")) {
                text = (Text)sibling.getFirstChild();
                list.iCopyrightMsg = text.getData().trim();
            } else if (sibling.getTagName().equals("copyProtectMark")) {
                Element mark = (Element)sibling.getFirstChild();
                if (mark.getTagName().equals("geometricalMark")) {
                    list.iMark = EllipticalMark.parse(mark);
                } else if (mark.getTagName().equals("labelMark")) {
                    list.iMark = LabelMark.parse(mark);
                }
            } else if (sibling.getTagName().equals("album")) {
                ViewerAlbum album = ViewerAlbum.parse(sibling);
                list.iAlbums.add(album);
            }
            sibling = (Element)sibling.getNextSibling();
        }
        return list;
    }

    private AlbumGroup() {
        this.iDate = new Date().getTime();
    }

    public LinkedList<ViewerAlbum> albums() {
        return this.iAlbums;
    }

    public long date() {
        return this.iDate;
    }

    public double maxViewFactor() {
        return this.iMaxViewFactor;
    }

    public int maxViewPixels() {
        return this.iMaxViewPixels;
    }

    public String copyrightMsg() {
        return this.iCopyrightMsg;
    }

    public CopyProtectMark mark() {
        return this.iMark;
    }

    public String name() {
        return this.iName;
    }

    public String dbPath() {
        return this.iDbPath;
    }

    public String serverRoot() {
        return this.iServerRoot;
    }

    public String toString() {
        String str = "AlbumGroup " + this.name() + ":";
        int count = 0;
        for (ViewerAlbum album : this.iAlbums) {
            if (count > 0) {
                str = String.valueOf(str) + ",";
            }
            str = String.valueOf(str) + " " + album.name();
            ++count;
        }
        return str;
    }

    private static class SAXErrorHandler
    implements ErrorHandler {
        private SAXErrorHandler() {
        }

        @Override
        public void error(SAXParseException xcp) throws SAXParseException {
            System.out.println("Error at line " + xcp.getLineNumber());
            throw xcp;
        }

        @Override
        public void fatalError(SAXParseException xcp) throws SAXParseException {
            this.error(xcp);
        }

        @Override
        public void warning(SAXParseException xcp) throws SAXParseException {
            this.error(xcp);
        }
    }

    public static class ViewerAlbum
    implements Serializable {
        private String iName = null;
        private Query iQuery = null;
        private boolean iUseMark = true;
        private boolean iZoomable = true;
        private String iAnnot = null;
        static final long serialVersionUID = 1343225182473172833L;

        public static ViewerAlbum parse(Element albumEle) throws Exception {
            ViewerAlbum album = new ViewerAlbum();
            Element name = (Element)albumEle.getFirstChild();
            Text text = (Text)name.getFirstChild();
            album.iName = text.getData().trim();
            Element useMark = (Element)name.getNextSibling();
            text = (Text)useMark.getFirstChild();
            Boolean bool = Boolean.valueOf(text.getData().trim());
            album.iUseMark = bool;
            Element zoomable = (Element)useMark.getNextSibling();
            text = (Text)zoomable.getFirstChild();
            bool = Boolean.valueOf(text.getData().trim());
            album.iZoomable = bool;
            return album;
        }

        private ViewerAlbum() {
        }

        public String name() {
            return this.iName;
        }

        public boolean isZoomable() {
            return this.iZoomable;
        }

        public boolean isUseMark() {
            return this.iUseMark;
        }

        public void setQuery(Query query) {
            this.iQuery = query;
        }

        public Query query() {
            return this.iQuery;
        }

        public String annot() {
            return this.iAnnot;
        }

        public void setAnnot(String annot) {
            this.iAnnot = annot;
        }
    }
}

