/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import java.util.TreeMap;

class UserMsg {
    private String iName = null;
    private String iMsg = null;
    private short iNumArgs = 0;
    private boolean iError = false;
    private Object iObj = null;
    public static final char SUBSTITUTE = '%';
    private static final String ARG1 = "%1";
    private static final String ARG2 = "%2";
    private static final String MSGPREFIX = "Format error, ";
    private static final String MSG1 = "Format error, one argument required: ";
    private static final String MSG2 = "Format error, two arguments required: ";

    public UserMsg(String name, String msg, boolean error) {
        this.iName = name;
        this.iMsg = msg;
        this.iError = error;
        int index = msg.indexOf(ARG1);
        if (index >= 0) {
            this.iNumArgs = (short)(this.iNumArgs + 1);
        }
        if ((index = this.iMsg.indexOf(ARG2)) >= 0) {
            this.iNumArgs = (short)(this.iNumArgs + 1);
        }
    }

    public String getName() {
        return this.iName;
    }

    public String getMsg() {
        return this.iMsg;
    }

    public boolean isError() {
        return this.iError;
    }

    public void setObj(Object obj) {
        this.iObj = obj;
    }

    public String format() {
        String format = null;
        format = this.iNumArgs == 0 ? this.iMsg.toString() : "Format error, argument[s] required: \"" + this.iMsg + "\"";
        format = this.addObj(format);
        return format;
    }

    public String format(String arg) {
        String format = null;
        if (this.iNumArgs == 1) {
            String msg = this.iMsg;
            msg = msg.replace(ARG1, arg);
            format = msg.toString();
        } else {
            format = "Format error, one argument required: \"" + this.iMsg + "\"";
        }
        return format;
    }

    public String format(String arg1, String arg2) {
        String format = null;
        if (this.iNumArgs == 2) {
            String msg = this.iMsg;
            msg = msg.replace(ARG1, arg1);
            msg = msg.replace(ARG2, arg2);
            format = msg.toString();
        } else {
            format = "Format error, two arguments required: \"" + this.iMsg + "\"";
        }
        format = this.addObj(format);
        return format;
    }

    public String formatXcp(Throwable xcp) {
        String format = null;
        if (this.iNumArgs == 1) {
            String msg = this.iMsg;
            String text = xcp.getClass().getName();
            msg = msg.replace(ARG1, text);
            format = msg.toString();
        } else {
            format = "Format error, one argument required: \"" + this.iMsg + "\"";
        }
        format = this.addObj(format);
        return format;
    }

    public String format(int arg) {
        String format = null;
        if (this.iNumArgs == 1) {
            String str = Integer.toString(arg);
            format = this.format(str);
        } else {
            format = "Format error, one argument required: \"" + this.iMsg + "\"";
        }
        format = this.addObj(format);
        return format;
    }

    public String format(int arg1, int arg2) {
        String format = null;
        if (this.iNumArgs == 2) {
            String str1 = Integer.toString(arg1);
            String str2 = Integer.toString(arg2);
            format = this.format(str1, str2);
        } else {
            format = "Format error, two arguments required: \"" + this.iMsg + "\"";
        }
        format = this.addObj(format);
        return format;
    }

    public String format(int arg1, String arg2) {
        String format = null;
        if (this.iNumArgs == 2) {
            String str1 = Integer.toString(arg1);
            format = this.format(str1, arg2);
        } else {
            format = "Format error, two arguments required: \"" + this.iMsg + "\"";
        }
        format = this.addObj(format);
        return format;
    }

    public String format(String arg1, int arg2) {
        String format = null;
        if (this.iNumArgs == 2) {
            String str2 = Integer.toString(arg2);
            format = this.format(arg1, str2);
        } else {
            format = "Format error, two arguments required: \"" + this.iMsg + "\"";
        }
        format = this.addObj(format);
        format = this.addObj(format);
        return format;
    }

    private String addObj(String format) {
        if (this.iObj != null && this.isError()) {
            String className = this.iObj.getClass().getName();
            int index = className.lastIndexOf(46);
            format = String.valueOf(format) + ", " + className.substring(index + 1);
        }
        return format;
    }

    public static class Database {
        private TreeMap<String, UserMsg> iMsgs = new TreeMap();

        public void add(UserMsg msg) throws Exception {
            UserMsg existing = this.iMsgs.get(msg.getName());
            if (existing != null) {
                Exception xcp = new Exception("Duplicate UserMsg name: " + msg.getName());
                throw xcp;
            }
            for (UserMsg aMsg : this.iMsgs.values()) {
                if (!aMsg.getMsg().equalsIgnoreCase(msg.getMsg())) continue;
                Exception xcp = new Exception("Duplicate UserMsg: " + aMsg.getMsg());
                throw xcp;
            }
            this.iMsgs.put(msg.getName(), msg);
        }

        public UserMsg get(String name, Object obj) {
            UserMsg msg = this.iMsgs.get(name);
            if (msg == null) {
                String text = new String("Message not found: %1");
                text = text.replace(UserMsg.ARG1, name);
                msg = new UserMsg("", text.toString(), true);
            }
            msg.setObj(obj);
            return msg;
        }

        public void add(Database db) throws Exception {
            for (UserMsg aMsg : db.iMsgs.values()) {
                this.add(aMsg);
            }
        }
    }
}

