/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.WrapTextMode;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextField;
import com.sun.star.text.XTextFrame;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XWordCursor;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XReplaceDescriptor;
import com.sun.star.util.XReplaceable;
import com.sun.star.util.XSearchDescriptor;
import com.sun.star.util.XSearchable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedList;
import unoofc.ODrawArea;
import unoofc.OEnumPropObj;
import unoofc.OEnv;
import unoofc.OFileFilter;
import unoofc.OPropObj;
import unoofc.OProps;
import unoofc.ORootDoc;
import unoofc.OStyle;
import unoofc.OTable;
import unoofc.OUtil;

public class OWriterDoc
extends ORootDoc {
    private XTextDocument iXDoc = null;
    private XTextCursor iTextCursor = null;
    private static final String NEWDOCURL = "private:factory/swriter";

    public OWriterDoc(String url) throws com.sun.star.uno.Exception {
        if (url == null) {
            url = NEWDOCURL;
        }
        url = OUtil.toUrl(url);
        this.makeXComp(url);
        this.iXDoc = (XTextDocument)OEnv.obj().obtain(XTextDocument.class, this.xGetXComp());
        this.setMSFactory((XMultiServiceFactory)OEnv.obj().obtain(XMultiServiceFactory.class, this.iXDoc));
        XText xText = this.iXDoc.getText();
        this.iTextCursor = xText.createTextCursor();
        if (url != null) {
            this.iTextCursor.gotoEnd(false);
        }
        this.initPropObj();
    }

    public int numChars() throws com.sun.star.uno.Exception {
        return (Integer)OUtil.prop(this.iXDoc, OProps.Document.CharacterCount.toString());
    }

    public int numWords() throws com.sun.star.uno.Exception {
        return (Integer)OUtil.prop(this.iXDoc, OProps.Document.WordCount.toString());
    }

    public int numParas() throws com.sun.star.uno.Exception {
        return (Integer)OUtil.prop(this.iXDoc, OProps.Document.ParagraphCount.toString());
    }

    public Collection<String> paraTexts() throws com.sun.star.uno.Exception {
        LinkedList<String> paras = new LinkedList<String>();
        this.iTextCursor.gotoStart(false);
        XParagraphCursor cursor = (XParagraphCursor)OEnv.obj().obtain(XParagraphCursor.class, this.iTextCursor);
        do {
            cursor.gotoEndOfParagraph(true);
            String para = cursor.getString();
            if (para.length() <= 0) continue;
            paras.add(para);
        } while (cursor.gotoNextParagraph(false));
        return paras;
    }

    public int replace(String from, String to) throws com.sun.star.uno.Exception {
        XReplaceable replaceable = (XReplaceable)OEnv.obj().obtain(XReplaceable.class, this.xGetXDoc());
        XReplaceDescriptor desc = replaceable.createReplaceDescriptor();
        desc.setSearchString(from);
        desc.setReplaceString(to);
        return replaceable.replaceAll((XSearchDescriptor)desc);
    }

    public void startPara(OStyle.Para style) throws com.sun.star.uno.Exception {
        if (this.numParas() > 0) {
            this.endPara();
        }
        XPropertySet props = (XPropertySet)OEnv.obj().obtain(XPropertySet.class, this.iTextCursor);
        props.setPropertyValue(OProps.Para.ParaStyleName.toString(), (Object)style.name());
    }

    public void endPara() {
        XText xText = this.iTextCursor.getText();
        xText.insertControlCharacter((XTextRange)this.iTextCursor, (short)0, false);
    }

    public void startPage(OStyle.Page style) throws com.sun.star.uno.Exception {
        XPropertySet props = (XPropertySet)OEnv.obj().obtain(XPropertySet.class, this.iTextCursor);
        props.setPropertyValue(OProps.Para.PageDescName.toString(), (Object)style.name());
    }

    public void addText(String text) {
        XText xText = this.iTextCursor.getText();
        xText.insertString((XTextRange)this.iTextCursor, text, false);
        this.iTextCursor.goRight((short)text.length(), true);
    }

    public void applyParaStyle(OStyle.Para style) throws com.sun.star.uno.Exception {
        XPropertySet props = (XPropertySet)OEnv.obj().obtain(XPropertySet.class, this.iTextCursor);
        props.setPropertyValue(OProps.Para.ParaStyleName.toString(), (Object)style.name());
    }

    public void insertTextFrame(OStyle.Frame style, Size size, String text, TextContentAnchorType anchor) throws com.sun.star.uno.Exception {
        XInterface obj = (XInterface)this.xGetMSFactory().createInstance("com.sun.star.text.TextFrame");
        XTextFrame xFrame = (XTextFrame)OEnv.obj().obtain(XTextFrame.class, obj);
        XShape xShape = (XShape)OEnv.obj().obtain(XShape.class, xFrame);
        xShape.setSize(size);
        XPropertySet props = (XPropertySet)OEnv.obj().obtain(XPropertySet.class, xFrame);
        props.setPropertyValue(OProps.Frame.FrameStyleName.toString(), (Object)style.name());
        props.setPropertyValue(OProps.TextShape.AnchorType.toString(), (Object)anchor);
        XText xText = this.iTextCursor.getText();
        xText.insertTextContent((XTextRange)this.iTextCursor, (XTextContent)xFrame, false);
        this.iTextCursor.gotoEnd(false);
        XText xFrameText = xFrame.getText();
        XTextCursor xFrameCursor = xFrameText.createTextCursor();
        xFrameText.insertString((XTextRange)xFrameCursor, text, false);
    }

    public void insertBitmap(OStyle.Frame style, Size size, String bitmapURL, TextContentAnchorType anchor) throws com.sun.star.uno.Exception {
        bitmapURL = OUtil.toUrl(bitmapURL);
        XInterface obj = (XInterface)this.xGetMSFactory().createInstance("com.sun.star.text.TextGraphicObject");
        XTextContent content = (XTextContent)OEnv.obj().obtain(XTextContent.class, obj);
        XPropertySet props = (XPropertySet)OEnv.obj().obtain(XPropertySet.class, obj);
        props.setPropertyValue(OProps.Frame.FrameStyleName.toString(), (Object)style.name());
        props.setPropertyValue(OProps.Graphic.GraphicURL.toString(), (Object)bitmapURL);
        props.setPropertyValue(OProps.TextShape.AnchorType.toString(), (Object)anchor);
        props.setPropertyValue(OProps.Frame.Surround.toString(), (Object)WrapTextMode.PARALLEL);
        ODrawArea area = new ODrawArea(new Point(0, 0), size);
        ODrawArea scaled = area.fitToBitmap(this, bitmapURL);
        props.setPropertyValue(OProps.Frame.Height.toString(), (Object)scaled.size().Height);
        props.setPropertyValue(OProps.Frame.Width.toString(), (Object)scaled.size().Width);
        XText xText = this.iTextCursor.getText();
        xText.insertTextContent((XTextRange)this.iTextCursor, content, false);
    }

    public OTable insertTable(int numRows, int numCols, TextContentAnchorType anchor) throws com.sun.star.uno.Exception {
        OTable table = new OTable(this, numRows, numCols);
        table.setProp(OProps.TextShape.AnchorType.toString(), (Object)anchor);
        XText xText = this.iTextCursor.getText();
        xText.insertTextContent((XTextRange)this.iTextCursor, (XTextContent)table.xGetXTable(), false);
        return table;
    }

    public Field insertField(TextFieldType type) throws com.sun.star.uno.Exception {
        OWriterDoc oWriterDoc = this;
        oWriterDoc.getClass();
        Field field = oWriterDoc.new Field(type);
        XText xText = this.iTextCursor.getText();
        xText.insertTextContent((XTextRange)this.iTextCursor, (XTextContent)field.xGetXField(), false);
        this.iTextCursor.gotoEnd(false);
        return field;
    }

    public int insertTextFile(File path, boolean trim) throws Exception {
        int count = 0;
        try (FileInputStream stream = null;){
            stream = new FileInputStream(path);
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (trim) {
                    line = line.trim();
                }
                this.addText(line);
                XText xText = this.iTextCursor.getText();
                xText.insertControlCharacter((XTextRange)this.iTextCursor, (short)0, false);
                ++count;
            }
            in.close();
        }
        return count;
    }

    public int setWordStyle(String word, OStyle.Char style) throws com.sun.star.uno.Exception {
        int count = 0;
        if (this.numWords() > 0) {
            WordCursor wCursor = new WordCursor();
            while (wCursor.hasNext()) {
                String aWord = wCursor.text();
                if (!aWord.equals(word)) continue;
                XWordCursor xCursor = wCursor.xGetXWordCursor();
                OUtil.setProp(xCursor, OProps.Char.CharStyleName.toString(), style.name());
                ++count;
            }
        }
        return count;
    }

    public String writeOdt(String url) throws com.sun.star.uno.Exception, com.sun.star.uno.Exception {
        return this.write(url, OFileFilter.ODT);
    }

    public XTextDocument xGetXDoc() {
        return this.iXDoc;
    }

    public XTextCursor xGetXTextCursor() {
        return this.iTextCursor;
    }

    @Override
    protected void initPropObj() throws com.sun.star.uno.Exception {
        this.setXObj((XInterface)this.iXDoc);
    }

    @Override
    protected void logDetails() throws com.sun.star.uno.Exception {
    }

    public class Field
    extends OEnumPropObj {
        private String iType = null;
        private XTextField iField = null;

        public Field(TextFieldType type) throws com.sun.star.uno.Exception {
            this.iType = type.toString();
            String serviceName = "com.sun.star.text.TextField." + this.iType;
            Object obj = OWriterDoc.this.xGetMSFactory().createInstance(serviceName);
            this.iField = (XTextField)OEnv.obj().obtain(XTextField.class, obj);
            this.setXObj((XInterface)this.iField);
        }

        public void append(String text) throws com.sun.star.uno.Exception {
            XText xText = (XText)OEnv.obj().obtain(XText.class, this.xGetXField());
            XTextCursor cursor = xText.createTextCursor();
            cursor.setString(text);
            cursor.gotoEnd(false);
        }

        public XTextField xGetXField() {
            return this.iField;
        }

        @Override
        protected void initPropObj() throws com.sun.star.uno.Exception {
            this.setXObj((XInterface)this.iField);
        }
    }

    public class ParaCursor
    implements TextCursor {
        private XParagraphCursor iCursor = null;
        private boolean iFirst = true;

        public ParaCursor() throws com.sun.star.uno.Exception {
            OWriterDoc.this.iTextCursor.gotoStart(false);
            this.iCursor = (XParagraphCursor)OEnv.obj().obtain(XParagraphCursor.class, OWriterDoc.this.iTextCursor);
        }

        @Override
        public boolean hasNext() {
            boolean has = false;
            if (this.iFirst) {
                try {
                    this.iCursor.gotoEndOfParagraph(false);
                    this.iCursor.gotoStartOfParagraph(false);
                    has = true;
                    this.iFirst = false;
                }
                catch (Exception exception) {}
            } else {
                has = this.iCursor.gotoNextParagraph(false);
            }
            return has;
        }

        @Override
        public String text() {
            this.iCursor.gotoEndOfParagraph(true);
            return this.iCursor.getString();
        }

        public XParagraphCursor xGetXWordCursor() {
            return this.iCursor;
        }
    }

    public static interface TextCursor {
        public boolean hasNext();

        public String text();

        public XTextCursor xGetXWordCursor();
    }

    public static enum TextFieldType {
        Annotation,
        Author,
        Bibliography,
        Chapter,
        CharacterCount,
        CombinedCharacters,
        ConditionalText,
        DateTime,
        DDE,
        EmbeddedObjectCount,
        ExtendedUser,
        FileName,
        GetExpression,
        GetReference,
        GraphicObjectCount,
        HiddenParagraph,
        HiddenText,
        Input,
        InputUser,
        JumpEdit,
        Macro,
        PageCount,
        PageNumber,
        ParagraphCount,
        ReferencePageGet,
        ReferencePageSet,
        Script,
        SetExpression,
        TableCount,
        TableFormula,
        TemplateName,
        User,
        WordCount;

    }

    public class TextSearch
    extends OPropObj {
        private XSearchDescriptor iXDesc = null;
        private XSearchable iXSearchable = null;

        public TextSearch() throws com.sun.star.uno.Exception {
            this.iXSearchable = (XSearchable)OEnv.obj().obtain(XSearchable.class, OWriterDoc.this.xGetXDoc());
            this.iXDesc = this.iXSearchable.createSearchDescriptor();
            this.initPropObj();
            this.useRegex(true);
            this.matchWordsOnly(true);
            this.matchCase(true);
            this.matchParaStyle(false);
            this.setProp("SearchSimilarity", false);
            this.setProp("SearchBackwards", false);
        }

        public void useRegex(boolean use) throws com.sun.star.uno.Exception {
            this.setProp("SearchRegularExpression", use);
        }

        public void matchWordsOnly(boolean wordsOnly) throws com.sun.star.uno.Exception {
            this.setProp("SearchWords", wordsOnly);
        }

        public void matchCase(boolean match) throws com.sun.star.uno.Exception {
            this.setProp("SearchCaseSensitive", match);
        }

        public void matchParaStyle(boolean match) throws com.sun.star.uno.Exception {
            this.setProp("SearchStyles", match);
        }

        public Collection<Result> perform(String pattern) throws com.sun.star.uno.Exception {
            LinkedList<Result> results = new LinkedList<Result>();
            this.setPattern(pattern);
            XIndexAccess access = this.iXSearchable.findAll(this.iXDesc);
            int i = 0;
            while (i < access.getCount()) {
                XTextRange range = (XTextRange)OEnv.obj().obtain(XTextRange.class, access.getByIndex(i));
                results.add(new Result(range));
                ++i;
            }
            return results;
        }

        public XSearchDescriptor xGetXSearchDesc() {
            return this.iXDesc;
        }

        protected void setPattern(String pattern) {
            this.iXDesc.setSearchString(pattern);
        }

        @Override
        protected void initPropObj() throws com.sun.star.uno.Exception {
            this.setXObj((XInterface)this.iXDesc);
        }

        public class Result {
            private XTextRange iRange = null;

            public String text() {
                return this.iRange.getString();
            }

            public void goTo() {
                OWriterDoc.this.iTextCursor.gotoRange(this.iRange, false);
            }

            public void goToEnd() {
                XTextRange range = this.iRange.getEnd();
                OWriterDoc.this.iTextCursor.gotoRange(range, false);
            }

            protected Result(XTextRange range) {
                this.iRange = range;
            }
        }
    }

    public class WordCursor
    implements TextCursor {
        private XWordCursor iCursor = null;
        private boolean iFirst = true;

        public WordCursor() throws com.sun.star.uno.Exception {
            OWriterDoc.this.iTextCursor.gotoStart(false);
            this.iCursor = (XWordCursor)OEnv.obj().obtain(XWordCursor.class, OWriterDoc.this.iTextCursor);
        }

        @Override
        public boolean hasNext() {
            boolean has = false;
            if (this.iFirst) {
                try {
                    this.iCursor.gotoEndOfWord(false);
                    this.iCursor.gotoStartOfWord(false);
                    has = true;
                    this.iFirst = false;
                }
                catch (Exception exception) {}
            } else {
                has = this.iCursor.gotoNextWord(false);
            }
            return has;
        }

        @Override
        public String text() {
            this.iCursor.gotoEndOfWord(true);
            return this.iCursor.getString();
        }

        public XWordCursor xGetXWordCursor() {
            return this.iCursor;
        }
    }
}

