/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.drawing.FillStyle;
import com.sun.star.drawing.LineStyle;
import com.sun.star.drawing.XShape;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import unoofc.OColor;
import unoofc.ODrawArea;
import unoofc.ODrawDoc;
import unoofc.OEnumPropObj;
import unoofc.OEnv;
import unoofc.OImpressDoc;
import unoofc.OProps;
import unoofc.ORootDoc;
import unoofc.OUserMsgs;
import unoofc.UserMsg;

public abstract class OShape
extends OEnumPropObj {
    protected XShape iXShape = null;

    public Size size() {
        return this.iXShape.getSize();
    }

    public Point position() {
        return this.iXShape.getPosition();
    }

    public String toString() {
        return "Shape: " + this.xGetXShape().getShapeType();
    }

    public void setSize(Size size) throws Exception {
        this.iXShape.setSize(size);
    }

    public void setPosition(Point pos) {
        this.iXShape.setPosition(pos);
    }

    public void setText(String text) throws Exception {
        XTextRange range = (XTextRange)OEnv.obj().obtain(XTextRange.class, this.xGetXObj());
        range.setString(text);
    }

    public void setSolidLine(OColor color, int width) throws Exception {
        this.setProp(OProps.Line.LineColor, (Object)color);
        this.setProp(OProps.Line.LineWidth, (Object)width);
        this.setProp(OProps.Line.LineStyle, (Object)LineStyle.SOLID);
    }

    public void setFillColor(OColor color) throws Exception {
        this.setProp(OProps.Fill.FillColor, (Object)color);
        this.setProp(OProps.Fill.FillStyle, (Object)FillStyle.SOLID);
    }

    public void setShadow(OColor color, int xSize, int ySize) throws Exception {
        this.setProp(OProps.Shadow.Shadow, (Object)true);
        this.setProp(OProps.Shadow.ShadowXDistance, (Object)xSize);
        this.setProp(OProps.Shadow.ShadowYDistance, (Object)ySize);
        this.setProp(OProps.Shadow.ShadowColor, (Object)color);
    }

    public void setLineDash(ODrawDoc.LineDash dash) throws Exception {
        this.setProp(OProps.Line.LineStyle.toString(), (Object)LineStyle.DASH);
        this.setProp(OProps.Line.LineDash.toString(), (Object)dash.getDash());
    }

    public XShape xGetXShape() {
        return this.iXShape;
    }

    protected OShape() {
    }

    protected OShape(ORootDoc doc, String className, ODrawArea area) throws Exception {
        Object service = doc.xGetMSFactory().createInstance(className);
        this.iXShape = (XShape)OEnv.obj().create(XShape.class, service);
        this.initPropObj();
        if (area != null) {
            this.iXShape.setSize(area.size());
            this.iXShape.setPosition(area.position());
        }
    }

    @Override
    protected void initPropObj() throws Exception {
        this.setXObj((XInterface)this.iXShape);
    }

    protected static OShape copy(XShape xShape) throws Exception {
        OShape shape = null;
        String type = xShape.getShapeType();
        if (type.equals(ODrawDoc.ShapeType.RECTANGLE.name())) {
            shape = new ODrawDoc.RectangleShape(xShape);
        } else if (type.equals(ODrawDoc.ShapeType.ELLIPSE.name())) {
            shape = new ODrawDoc.EllipseShape(xShape);
        } else if (type.equals(ODrawDoc.ShapeType.TEXT.name())) {
            shape = new ODrawDoc.TextShape(xShape);
        } else if (type.equals(ODrawDoc.ShapeType.GRAPHIC.name())) {
            shape = new ODrawDoc.BitmapShape(xShape);
        } else if (type.equals(ODrawDoc.ShapeType.LINE.name())) {
            shape = new ODrawDoc.LineShape(xShape);
        } else if (type.equals(ODrawDoc.ShapeType.CONNECTOR.name())) {
            shape = new ODrawDoc.ConnectorShape(xShape);
        } else if (type.equals(OImpressDoc.ShapeType.OUTLINER.name())) {
            shape = new OImpressDoc.OutlinerShape(xShape);
        } else if (type.equals(OImpressDoc.ShapeType.TITLETEXT.name())) {
            shape = new OImpressDoc.TitleTextShape(xShape);
        } else if (type.equals(OImpressDoc.ShapeType.DATETIME.name())) {
            shape = new OImpressDoc.DateTimeShape(xShape);
        } else if (type.equals(OImpressDoc.ShapeType.FOOTER.name())) {
            shape = new OImpressDoc.FooterShape(xShape);
        } else if (type.equals(OImpressDoc.ShapeType.SLIDENUMBER.name())) {
            shape = new OImpressDoc.SlideNumberShape(xShape);
        } else if (type.equals(OImpressDoc.ShapeType.SUBTITLE.name())) {
            shape = new OImpressDoc.SubtitleShape(xShape);
        } else {
            UserMsg msg = OUserMsgs.msg("no-shape");
            OEnv.throwError(msg.format(type));
        }
        return shape;
    }
}

