/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.awt.XBitmap;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import com.sun.star.util.DateTime;
import com.sun.star.util.XCloseable;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import unoofc.OCalcDoc;
import unoofc.ODrawDoc;
import unoofc.OEnv;
import unoofc.OFileFilter;
import unoofc.OImpressDoc;
import unoofc.OPropObj;
import unoofc.OProps;
import unoofc.OShape;
import unoofc.OStyle;
import unoofc.OUserMsgs;
import unoofc.OUtil;
import unoofc.OWriterDoc;
import unoofc.UserMsg;

public abstract class ORootDoc
extends OPropObj {
    private XMultiServiceFactory iFactory = null;
    private XComponent iXComp = null;
    private String iUrl = null;

    public static ORootDoc read(String url) throws Exception {
        ORootDoc doc = null;
        OFileFilter filter = OFileFilter.fromUrl(url = OUtil.toUrl(url));
        doc = filter.equals(OFileFilter.ODT) ? new OWriterDoc(url) : (filter.equals(OFileFilter.ODS) ? new OCalcDoc(url) : (filter.equals(OFileFilter.ODG) ? new ODrawDoc(url) : new OImpressDoc(url)));
        doc.setupStyles();
        return doc;
    }

    public Info info() throws Exception {
        return new Info();
    }

    public String url() {
        return this.iUrl;
    }

    public int numPages() throws Exception {
        int num = 0;
        XDrawPages pages = this.getXPages();
        if (pages != null) {
            num = pages.getCount();
        }
        return num;
    }

    public int numShapes() throws Exception {
        int num = 0;
        XDrawPages xPages = this.getXPages();
        XIndexAccess access = (XIndexAccess)OEnv.obj().obtain(XIndexAccess.class, xPages);
        int i = 0;
        while (i < access.getCount()) {
            XDrawPage page = (XDrawPage)OEnv.obj().obtain(XDrawPage.class, xPages.getByIndex(i));
            num += page.getCount();
            ++i;
        }
        return num;
    }

    public Collection<OShape> shapes() throws Exception {
        LinkedList<OShape> shapes = new LinkedList<OShape>();
        XDrawPages xPages = this.getXPages();
        XIndexAccess access = (XIndexAccess)OEnv.obj().obtain(XIndexAccess.class, xPages);
        int i = 0;
        while (i < access.getCount()) {
            XDrawPage page = (XDrawPage)OEnv.obj().obtain(XDrawPage.class, xPages.getByIndex(i));
            XIndexAccess pageAccess = (XIndexAccess)OEnv.obj().obtain(XIndexAccess.class, page);
            int j = 0;
            while (j < pageAccess.getCount()) {
                XShape shape = (XShape)OEnv.obj().obtain(XShape.class, pageAccess.getByIndex(j));
                try {
                    shapes.add(OShape.copy(shape));
                }
                catch (Exception xcp) {
                    OEnv.obj().log("Shape not implemented: " + shape.getShapeType(), true);
                }
                ++j;
            }
            ++i;
        }
        return shapes;
    }

    public Collection<OShape> shapesByType(String typeName) throws Exception {
        LinkedList<OShape> shapes = new LinkedList<OShape>();
        XDrawPages xPages = this.getXPages();
        XIndexAccess access = (XIndexAccess)OEnv.obj().obtain(XIndexAccess.class, xPages);
        int i = 0;
        while (i < access.getCount()) {
            XDrawPage page = (XDrawPage)OEnv.obj().obtain(XDrawPage.class, xPages.getByIndex(i));
            XIndexAccess pageAccess = (XIndexAccess)OEnv.obj().obtain(XIndexAccess.class, page);
            int j = 0;
            while (j < pageAccess.getCount()) {
                XShape shape = (XShape)OEnv.obj().obtain(XShape.class, pageAccess.getByIndex(j));
                if (shape.getShapeType().equals(typeName)) {
                    shapes.add(OShape.copy(shape));
                }
                ++j;
            }
            ++i;
        }
        return shapes;
    }

    public void logShapes() throws Exception {
        Collection<OShape> shapes = this.shapes();
        LinkedList<String> strs = new LinkedList<String>();
        for (OShape shape : shapes) {
            strs.add(shape.toString());
        }
        OEnv.obj().log(strs, "Document shapes");
    }

    public int numStyles() throws Exception {
        int num = 0;
        Collection<OStyle.Family> families = this.styleFamilies();
        for (OStyle.Family family : families) {
            num += this.styles(family, false).size();
        }
        return num;
    }

    public Collection<OStyle.Family> styleFamilies() throws Exception {
        String[] names;
        LinkedList<OStyle.Family> families = new LinkedList<OStyle.Family>();
        XStyleFamiliesSupplier supplier = (XStyleFamiliesSupplier)OEnv.obj().obtain(XStyleFamiliesSupplier.class, this.iXComp);
        XNameAccess nameAccess = supplier.getStyleFamilies();
        String[] stringArray = names = nameAccess.getElementNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            families.add(OStyle.Family.byName(name));
            ++n2;
        }
        return families;
    }

    public Collection<OStyle> styles(boolean onlyInUse) throws Exception, Exception {
        LinkedList<OStyle> styles = new LinkedList<OStyle>();
        Collection<OStyle.Family> families = this.styleFamilies();
        for (OStyle.Family family : families) {
            Collection<OStyle> famStyles = this.styles(family, onlyInUse);
            styles.addAll(famStyles);
        }
        return styles;
    }

    public Collection<OStyle> styles(OStyle.Family family, boolean onlyInUse) throws Exception {
        LinkedList<OStyle> styles = new LinkedList<OStyle>();
        XStyleFamiliesSupplier supplier = (XStyleFamiliesSupplier)OEnv.obj().obtain(XStyleFamiliesSupplier.class, this.xGetXComp());
        XNameAccess nameAccess = supplier.getStyleFamilies();
        try {
            String[] names;
            XNameContainer container = (XNameContainer)OEnv.obj().obtain(XNameContainer.class, nameAccess.getByName(family.name()));
            nameAccess = (XNameAccess)OEnv.obj().obtain(XNameContainer.class, container);
            String[] stringArray = names = nameAccess.getElementNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                OStyle style = this.style(family, name);
                XStyle xStyle = style.xGetXStyle();
                if (xStyle.isInUse()) {
                    styles.add(style);
                } else if (!onlyInUse) {
                    styles.add(style);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return styles;
    }

    public OStyle style(OStyle.Family family, String name) throws Exception, Exception {
        OStyle style = null;
        if (family == OStyle.Family.CHARACTER) {
            style = new OStyle.Char(this, name);
        } else if (family == OStyle.Family.PARAGRAPH) {
            style = new OStyle.Para(this, name);
        } else if (family == OStyle.Family.FRAME) {
            style = new OStyle.Frame(this, name);
        } else if (family == OStyle.Family.PAGE) {
            style = new OStyle.Page(this, name);
        } else if (family == OStyle.Family.NUMBERING) {
            style = new OStyle.Numbering(this, name);
        } else if (family == OStyle.Family.TABLE) {
            style = new OStyle.Table(this, name);
        } else if (family == OStyle.Family.CELL) {
            style = new OStyle.Cell(this, name);
        } else if (family == OStyle.Family.SHAPE) {
            style = new OStyle.Shape(this, name);
        } else if (family == OStyle.Family.GRAPHICS) {
            style = new OStyle.Graphics(this, name);
        } else if (family == OStyle.Family.DRAWCELL) {
            style = new OStyle.DrawCell(this, name);
        } else if (family == OStyle.Family.DRAWTABLE) {
            style = new OStyle.DrawTable(this, name);
        } else if (family == OStyle.Family.Default) {
            style = new OStyle.Default(this, name);
        }
        if (style == null) {
            UserMsg msg = OUserMsgs.msg("no-style");
            OEnv.throwError(msg.format(name));
        }
        return style;
    }

    public void logStyles(boolean onlyInUse) throws Exception {
        Collection<OStyle> styles = this.styles(onlyInUse);
        LinkedList<String> strs = new LinkedList<String>();
        for (OStyle style : styles) {
            strs.add(style.toString());
        }
        OEnv.obj().log(strs, "Document styles");
    }

    public void logFields() throws Exception {
        LinkedList<String> fields = new LinkedList<String>();
        XTextFieldsSupplier supp = (XTextFieldsSupplier)OEnv.obj().create(XTextFieldsSupplier.class, this.xGetXDoc());
        XEnumeration enumer = supp.getTextFields().createEnumeration();
        while (enumer.hasMoreElements()) {
            Object obj = enumer.nextElement();
            fields.add(obj.toString());
        }
        OEnv.obj().log(fields, "Document fields");
    }

    public void logSummary() throws Exception {
        this.info().log();
        this.logShapes();
        this.logStyles(true);
        OEnv.obj().logProps(this.xGetXDoc(), "Document properties");
        this.logDetails();
    }

    public void logServices() throws Exception {
        LinkedList<String> services = OUtil.arrayToColl(this.iFactory.getAvailableServiceNames());
        OEnv.obj().log(services, "Document services");
    }

    public String toString() {
        String str = String.valueOf(this.getClass().getName()) + ": ";
        try {
            str = String.valueOf(str) + this.numPages() + " pages, ";
        }
        catch (Exception xcp) {
            str = String.valueOf(str) + "? pages, ";
        }
        try {
            str = String.valueOf(str) + this.numStyles() + " styles, ";
        }
        catch (Exception xcp) {
            str = String.valueOf(str) + "? styles";
        }
        try {
            str = String.valueOf(str) + this.numShapes() + " shapes";
        }
        catch (Exception xcp) {
            str = String.valueOf(str) + "? shapes";
        }
        return str;
    }

    public void deleteStyle(OStyle.Family family, String name) throws Exception, Exception {
        XStyleFamiliesSupplier supplier = (XStyleFamiliesSupplier)OEnv.obj().obtain(XStyleFamiliesSupplier.class, this.xGetXComp());
        XNameAccess nameAccess = supplier.getStyleFamilies();
        XNameContainer container = (XNameContainer)OEnv.obj().obtain(XNameContainer.class, nameAccess.getByName(family.name()));
        container.removeByName(name);
    }

    public void setupStyles() throws Exception {
    }

    public String write(String url, OFileFilter filter) throws Exception, Exception {
        url = OUtil.toUrl(url);
        LinkedList<PropertyValue> props = ORootDoc.baseProperties(filter);
        PropertyValue prop = new PropertyValue();
        prop.Name = OProps.MediaDescriptor.Overwrite.toString();
        prop.Value = Boolean.TRUE;
        props.add(prop);
        return this.writeByProps(url, filter, props);
    }

    public String writeProtected(String url, OFileFilter filter, String password) throws Exception {
        url = OUtil.toUrl(url);
        LinkedList<PropertyValue> props = ORootDoc.baseProperties(filter);
        PropertyValue prop = new PropertyValue();
        prop.Name = OProps.MediaDescriptor.Overwrite.toString();
        prop.Value = Boolean.TRUE;
        props.add(prop);
        prop = new PropertyValue();
        prop.Name = OProps.MediaDescriptor.Password.toString();
        prop.Value = password;
        props.add(prop);
        return this.writeByProps(url, filter, props);
    }

    public void close() throws Exception {
        XCloseable closeable = (XCloseable)OEnv.obj().obtain(XCloseable.class, this.iXComp);
        closeable.close(false);
    }

    public XMultiServiceFactory xGetMSFactory() {
        return this.iFactory;
    }

    public XComponent xGetXComp() {
        return this.iXComp;
    }

    protected ORootDoc() {
    }

    protected void setMSFactory(XMultiServiceFactory factory) {
        this.iFactory = factory;
    }

    protected void setUrl(String url) {
        this.iUrl = OUtil.toUrl(url);
    }

    protected void makeXComp(String url) throws Exception {
        OFileFilter filter;
        url = url.replace('\\', '/');
        PropertyValue[] props = new PropertyValue[]{};
        if (!url.startsWith("private") && (filter = OFileFilter.fromUrl(url)).isTemplate()) {
            props = new PropertyValue[]{new PropertyValue()};
            props[0].Name = "IsTemplate";
            props[0].Value = new Boolean(false);
        }
        this.setUrl(url);
        this.iXComp = OEnv.obj().xGetCompLoader().loadComponentFromURL(url, "_default", 0, props);
        this.setXObj((XInterface)this.iXComp);
    }

    protected XDrawPages getXPages() throws Exception {
        XDrawPages pages = null;
        XDrawPagesSupplier supplier = (XDrawPagesSupplier)OEnv.obj().obtain(XDrawPagesSupplier.class, this.xGetXComp());
        if (supplier != null) {
            pages = supplier.getDrawPages();
        }
        return pages;
    }

    protected XBitmap readBitmap(String url) throws Exception {
        url = OUtil.toUrl(url);
        Object obj = this.xGetMSFactory().createInstance("com.sun.star.drawing.BitmapTable");
        XNameContainer container = (XNameContainer)OEnv.obj().obtain(XNameContainer.class, obj);
        XNameAccess access = (XNameAccess)OEnv.obj().obtain(XNameAccess.class, container);
        try {
            obj = access.getByName(url);
        }
        catch (Exception xcp) {
            container.insertByName(url, (Object)url);
            String[] names = access.getElementNames();
            if (names.length == 0) {
                UserMsg msg = OUserMsgs.msg("no-bitmap");
                OEnv.throwError(msg.format(url));
            }
            obj = access.getByName(url);
        }
        XBitmap bitmap = (XBitmap)OEnv.obj().obtain(XBitmap.class, obj);
        return bitmap;
    }

    protected abstract void logDetails() throws Exception;

    protected abstract XInterface xGetXDoc();

    private String writeByProps(String url, OFileFilter filter, Collection<PropertyValue> props) throws Exception {
        int index = (url = OUtil.toUrl(url)).lastIndexOf(46);
        if (index >= 0) {
            url = url.substring(0, index);
        }
        url = String.valueOf(url) + filter.extension();
        XStorable storable = (XStorable)OEnv.obj().obtain(XStorable.class, this.iXComp);
        PropertyValue[] theProps = new PropertyValue[props.size()];
        int i = 0;
        for (PropertyValue prop : props) {
            theProps[i] = new PropertyValue();
            theProps[i].Name = prop.Name;
            theProps[i++].Value = prop.Value;
        }
        storable.storeAsURL(url, theProps);
        UserMsg msg = OUserMsgs.msg("wrote-doc");
        String text = msg.format(url);
        OEnv.obj().log(text, false);
        return url;
    }

    private static LinkedList<PropertyValue> baseProperties(OFileFilter filter) {
        LinkedList<PropertyValue> props = new LinkedList<PropertyValue>();
        PropertyValue prop = new PropertyValue();
        prop.Name = OProps.MediaDescriptor.FilterName.toString();
        prop.Value = filter.name();
        props.add(prop);
        prop = new PropertyValue();
        prop.Name = OProps.MediaDescriptor.FilterOptions.toString();
        prop.Value = filter.option();
        props.add(prop);
        return props;
    }

    public class Info {
        private XDocumentProperties iProps = null;

        public String author() {
            return this.iProps.getAuthor();
        }

        public String generator() {
            return this.iProps.getGenerator();
        }

        public Calendar creationDate() {
            DateTime date = this.iProps.getCreationDate();
            return OUtil.calFromdateTime(date);
        }

        public String title() {
            return this.iProps.getTitle();
        }

        public String subject() {
            return this.iProps.getSubject();
        }

        public String modifiedBy() {
            return this.iProps.getModifiedBy();
        }

        public Calendar modificationDate() {
            return OUtil.calFromdateTime(this.iProps.getModificationDate());
        }

        public int editingCycles() {
            return this.iProps.getEditingCycles();
        }

        public int editingDuration() {
            return this.iProps.getEditingDuration();
        }

        public void log() throws Exception {
            LinkedList<String> strs = new LinkedList<String>();
            strs.add("Subject: " + this.subject());
            strs.add("Author: " + this.author());
            strs.add("Generator: " + this.generator());
            strs.add("Creation date: " + this.creationDate().getTime().toString());
            strs.add("Modification date: " + this.modificationDate().getTime().toString());
            strs.add("Modified by: " + this.modifiedBy());
            strs.add("Editing cycles: " + this.editingCycles());
            strs.add("Editing duration: " + this.editingDuration());
            OEnv.obj().log(strs, "Document information");
        }

        public XDocumentProperties xGetDocProps() {
            return this.iProps;
        }

        private Info() throws Exception {
            XDocumentPropertiesSupplier supplier = (XDocumentPropertiesSupplier)OEnv.obj().obtain(XDocumentPropertiesSupplier.class, ORootDoc.this.xGetXComp());
            this.iProps = supplier.getDocumentProperties();
        }
    }
}

