/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import mlib.MString;

public abstract class OLogger {
    private boolean iEnabled = true;
    private boolean iIncludeTime = false;
    private String iPrefix = "";
    private OLogger iNext = null;
    private int iNumWrites = 0;
    private int iMaxWrites = Integer.MAX_VALUE;
    public static final char SPACE = ' ';
    public static final char TAB = '\t';
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String INDENT = "   ";
    public static final String DOUBLEINDENT = "      ";
    public static final String NEWLINE = "\r\n";
    private static final String ERROR = "***";
    private static final String OK = "OK";
    private static final SimpleDateFormat DAYTIME = new SimpleDateFormat("yyyy-MM-dd'@'HH:mm:ss");

    public boolean isEnabled() {
        return this.iEnabled;
    }

    public boolean isIncludeTime() {
        return this.iIncludeTime;
    }

    public String prefix() {
        return this.iPrefix;
    }

    public OLogger nextLogger() {
        return this.iNext;
    }

    public int maxWrites() {
        return this.iMaxWrites;
    }

    public void setEnabled(boolean enabled) {
        this.iEnabled = enabled;
    }

    public void setIncludeTime(boolean includeTime) {
        this.iIncludeTime = includeTime;
    }

    public void setPrefix(String prefix) {
        this.iPrefix = prefix;
        if (this.iNext != null) {
            this.iNext.setPrefix(prefix);
        }
    }

    public void setNext(OLogger next) {
        this.iNext = next;
    }

    public void setMaxWrites(int maxWrites) {
        this.iMaxWrites = maxWrites;
    }

    public void writeln(String msg, boolean error) {
        if (this.isEnabled() && this.iNumWrites < this.iMaxWrites) {
            if (!msg.endsWith(NEWLINE)) {
                msg = String.valueOf(msg) + NEWLINE;
            }
            this.write(msg, error);
            ++this.iNumWrites;
            if (this.nextLogger() != null) {
                this.nextLogger().writeln(msg, error);
            }
        }
    }

    protected abstract void write(String var1, boolean var2);

    protected String format(String msg, boolean error) {
        MString formatted = new MString(msg);
        try {
            formatted.trim(' ');
            if (formatted.charAt(0) == '\r') {
                formatted.trimHead('\r');
                formatted.insert(this.iPrefix, 0);
            } else {
                formatted.insert(this.iPrefix, 0);
            }
            boolean isOk = msg.startsWith(OK);
            if (this.isIncludeTime() && !isOk) {
                Date date = new Date();
                formatted.insert(' ', 0);
                formatted.insert(DAYTIME.format(date), 0);
            }
            if (error) {
                formatted.insert(ERROR, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formatted.toString();
    }

    public static class Empty
    extends OLogger {
        @Override
        public void write(String msg, boolean error) {
        }
    }

    public static class File
    extends OLogger {
        private PrintWriter iOut = null;

        public File(String path, boolean append) throws Exception {
            this.iOut = new PrintWriter(new BufferedWriter(new FileWriter(path, append)));
        }

        @Override
        public void write(String msg, boolean error) {
            if (this.isEnabled()) {
                msg = this.format(msg, error);
                this.iOut.print(msg);
                this.iOut.flush();
            }
        }
    }

    public static class System
    extends OLogger {
        @Override
        public void write(String msg, boolean error) {
            if (this.isEnabled()) {
                msg = this.format(msg, error);
                java.lang.System.out.print(msg);
            }
        }
    }
}

