/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import java.util.TreeMap;
import unoofc.OEnv;
import unoofc.OUserMsgs;
import unoofc.UserMsg;

public class OFileFilter
implements Comparable<OFileFilter> {
    private String iName = null;
    private String iOption = null;
    private String iExt = null;
    private boolean iTemplate = false;
    private static TreeMap<String, OFileFilter> TheFilters = new TreeMap();
    public static final OFileFilter ODT = new OFileFilter("writer8", "", ".odt", false);
    public static final OFileFilter OTT = new OFileFilter("writer8_template", "", ".ott", true);
    public static final OFileFilter ODS = new OFileFilter("calc8", "", ".ods", false);
    public static final OFileFilter OTS = new OFileFilter("calc8_template", "", ".ots", true);
    public static final OFileFilter ODP = new OFileFilter("impress8", "", ".odp", false);
    public static final OFileFilter OTP = new OFileFilter("impress8_template", "", ".otp", true);
    public static final OFileFilter ODG = new OFileFilter("draw8", "", ".odg", false);
    public static final OFileFilter OTG = new OFileFilter("draw8_template", "", ".otg", true);
    public static final OFileFilter ODB = new OFileFilter("StarOffice XML (Base)", "", ".odb", false);
    public static final OFileFilter DOCX = new OFileFilter("MS Word 2007 XML", "", ".docx", false);
    public static final OFileFilter XLSX = new OFileFilter("Calc MS Excel 2007 XML", "", ".xlsx", false);
    public static final OFileFilter TXT = new OFileFilter("Text", "Text", ".txt", false);
    public static final OFileFilter CSV = new OFileFilter("Text - txt - csv (StarCalc)", "Text CSV", ".csv", false);

    public static OFileFilter fromUrl(String url) throws OEnv.DocException {
        int index = url.lastIndexOf(46);
        String ext = url.substring(index);
        OFileFilter filter = TheFilters.get(ext);
        if (filter == null) {
            UserMsg msg = OUserMsgs.msg("no-filter");
            OEnv.throwError(msg.format(url));
        }
        return filter;
    }

    public OFileFilter(String name, String option, String extension, boolean template) {
        this.iName = name;
        this.iOption = option;
        this.iExt = extension;
        this.iTemplate = template;
        TheFilters.put(extension, this);
    }

    public String name() {
        return this.iName;
    }

    public String option() {
        return this.iOption;
    }

    public String extension() {
        return this.iExt;
    }

    public boolean isTemplate() {
        return this.iTemplate;
    }

    public String toString() {
        return this.iName;
    }

    @Override
    public int compareTo(OFileFilter filter) {
        int result = 0;
        if (filter != this) {
            result = -1;
            if (filter != null) {
                result = this.iName.compareTo(filter.iName);
            }
        }
        return result;
    }

    public boolean equals(OFileFilter filter) {
        return this.compareTo(filter) == 0;
    }
}

