/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.util.Collection;
import java.util.TreeSet;
import unoofc.OLogger;
import unoofc.OPropObj;
import unoofc.OUserMsgs;
import unoofc.OUtil;
import unoofc.UserMsg;

public class OEnv {
    private OLogger iLogger = new OLogger.System();
    private XComponentContext iContext = null;
    private XMultiComponentFactory iCompFactory = null;
    private XDesktop iDesktop = null;
    private XComponentLoader iCompLoader = null;
    private boolean iLogInterfaces = false;
    private static OEnv Singleton = null;
    private static String ERRORPREFIX = "***OEnv*** ";
    private static final String VERSION = "unoofc version 27-Aug-2024";
    protected static final char DIRDELIM = '/';

    public static OEnv obj() throws Exception {
        if (Singleton == null) {
            try {
                Singleton = new OEnv();
                OEnv.Singleton.iContext = Bootstrap.bootstrap();
                OEnv.Singleton.iCompFactory = OEnv.Singleton.iContext.getServiceManager();
                OEnv.Singleton.iDesktop = (XDesktop)Singleton.create(XDesktop.class, "com.sun.star.frame.Desktop");
                OEnv.Singleton.iCompLoader = (XComponentLoader)Singleton.obtain(XComponentLoader.class, OEnv.Singleton.iDesktop);
                OEnv.Singleton.iLogger.writeln(VERSION, false);
            }
            catch (BootstrapException xcp) {
                UserMsg msg = OUserMsgs.msg("doc-error");
                OEnv.throwError(msg.format(((Object)((Object)xcp)).getClass().getName()));
            }
            catch (Exception xcp) {
                UserMsg msg = OUserMsgs.msg("doc-error");
                OEnv.throwError(msg.format(((Object)((Object)xcp)).getClass().getName()));
            }
        }
        return Singleton;
    }

    public void setLogger(OLogger logger) {
        this.iLogger = this.iLogger != null ? logger : new OLogger.Empty();
    }

    public void log(String msg, boolean isError) {
        this.iLogger.writeln(msg, isError);
    }

    public void log(Collection<String> strs, String title) {
        this.iLogger.writeln(String.valueOf(title) + ":", false);
        String prefix = this.iLogger.prefix();
        this.iLogger.setPrefix(String.valueOf(prefix) + "   ");
        for (String str : strs) {
            this.iLogger.writeln(str, false);
        }
        this.iLogger.setPrefix(prefix);
    }

    public void logProps(OPropObj obj, String title) throws Exception {
        this.logProps(obj.xGetXObj(), title);
    }

    public boolean terminate() {
        boolean result = true;
        if (OEnv.Singleton.iDesktop != null) {
            result = OEnv.Singleton.iDesktop.terminate();
        }
        return result;
    }

    public XComponentContext xGetContext() {
        return this.iContext;
    }

    public XComponentLoader xGetCompLoader() {
        return this.iCompLoader;
    }

    protected XInterface obtain(Class<?> interfaceType, Object xObj) throws Exception {
        XInterface xInter = (XInterface)UnoRuntime.queryInterface(interfaceType, (Object)xObj);
        if (xInter == null) {
            UserMsg msg = OUserMsgs.msg("no-interface");
            OEnv.throwError(msg.format(interfaceType.getName()));
        } else if (this.iLogInterfaces && this.iLogger != null) {
            String msg = "Obtained: " + interfaceType.getName();
            this.iLogger.writeln(msg, false);
        }
        return xInter;
    }

    protected Object create(Class<?> interfaceType, Object xService) throws Exception {
        Object xInter = UnoRuntime.queryInterface(interfaceType, (Object)xService);
        if (xInter == null) {
            UserMsg msg = OUserMsgs.msg("no-interface");
            OEnv.throwError(msg.format(interfaceType.getName()));
        } else if (this.iLogInterfaces && this.iLogger != null) {
            String msg = "Created: " + interfaceType.getName();
            this.iLogger.writeln(msg, false);
        }
        return xInter;
    }

    protected Object create(Class<?> interfaceType, String serviceName) throws Exception {
        Object xInter = null;
        String text = String.valueOf(interfaceType.getName()) + " for service " + serviceName;
        try {
            Object comp = this.iCompFactory.createInstanceWithContext(serviceName, this.iContext);
            xInter = UnoRuntime.queryInterface(interfaceType, (Object)comp);
            if (xInter == null) {
                UserMsg msg = OUserMsgs.msg("no-interface");
                OEnv.throwError(msg.format(text));
            } else if (this.iLogInterfaces && this.iLogger != null) {
                String msg = "Created: " + text;
                this.iLogger.writeln(msg, false);
            }
        }
        catch (Exception xcp) {
            UserMsg msg = OUserMsgs.msg("no-interface");
            OEnv.throwError(msg.format(text));
        }
        return xInter;
    }

    protected Collection<String> componentServices() {
        String[] svcs = this.iCompFactory.getAvailableServiceNames();
        return OUtil.arrayToColl(svcs);
    }

    protected void logProps(XInterface obj, String title) throws Exception {
        Property[] props;
        TreeSet<String> ordered = new TreeSet<String>();
        XPropertySet set = OUtil.propSet(obj);
        XPropertySetInfo info = set.getPropertySetInfo();
        Property[] propertyArray = props = info.getProperties();
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            String value = "VOID";
            try {
                value = set.getPropertyValue(prop.Name).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String str = String.valueOf(prop.Name) + ", " + prop.Type + ", " + value;
            ordered.add(str);
            ++n2;
        }
        this.log(ordered, title);
    }

    protected void setLogInterfaces(boolean log) {
        this.iLogInterfaces = log;
    }

    protected static void throwError(String msg) throws DocException {
        throw new DocException(String.valueOf(ERRORPREFIX) + msg);
    }

    private OEnv() {
    }

    public static class DocException
    extends Exception {
        protected DocException(String msg) {
            super(msg);
        }
    }
}

