/*
 * Decompiled with CFR 0.152.
 */
package unoofc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNamed;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XCellRangeData;
import com.sun.star.sheet.XSheetCellCursor;
import com.sun.star.sheet.XSheetCellRange;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XUsedAreaCursor;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XColumnRowRange;
import com.sun.star.table.XTableCharts;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.table.XTableColumns;
import com.sun.star.table.XTableRows;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XMergeable;
import com.sun.star.util.XNumberFormatTypes;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XProtectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeMap;
import unoofc.ODrawArea;
import unoofc.ODrawDoc;
import unoofc.OEnumPropObj;
import unoofc.OEnv;
import unoofc.OFileFilter;
import unoofc.OProps;
import unoofc.ORootDoc;
import unoofc.OStyle;
import unoofc.OTable;
import unoofc.OUserMsgs;
import unoofc.OUtil;
import unoofc.UserMsg;

public class OCalcDoc
extends ORootDoc {
    private XSpreadsheetDocument iXDoc = null;
    private TreeMap<Short, Sheet> iSheetsByNum = new TreeMap();
    private TreeMap<String, Sheet> iSheetsByName = new TreeMap();
    private static final String NEWDOCURL = "private:factory/scalc";

    public OCalcDoc(String url) throws com.sun.star.uno.Exception {
        if (url == null) {
            url = NEWDOCURL;
        }
        url = OUtil.toUrl(url);
        this.makeXComp(url);
        this.iXDoc = (XSpreadsheetDocument)OEnv.obj().obtain(XSpreadsheetDocument.class, this.xGetXComp());
        this.setMSFactory((XMultiServiceFactory)OEnv.obj().obtain(XMultiServiceFactory.class, this.iXDoc));
        this.setupSheets();
        this.initPropObj();
    }

    public ArrayList<Sheet> sheets() {
        ArrayList<Sheet> sheets = new ArrayList<Sheet>();
        for (Sheet sheet : this.iSheetsByName.values()) {
            sheets.add(sheet);
        }
        return sheets;
    }

    public Sheet sheet(short number) {
        return this.iSheetsByNum.get(number);
    }

    public Sheet sheet(String name) {
        return this.iSheetsByName.get(name);
    }

    @Override
    public String toString() {
        String str = "CalcDoc: ";
        try {
            int num = this.sheets().size();
            str = String.valueOf(str) + num + " sheets";
        }
        catch (Exception xcp) {
            str = String.valueOf(str) + "? sheets,";
        }
        return str;
    }

    public Sheet insertSheet(short number, String name) throws com.sun.star.uno.Exception {
        this.iXDoc.getSheets().insertNewByName(name, number);
        this.setupSheets();
        return this.iSheetsByNum.get(number);
    }

    public void insertBitmap(Sheet sheet, ODrawArea area, String bitmapURL) throws com.sun.star.uno.Exception {
        bitmapURL = OUtil.toUrl(bitmapURL);
        XNameContainer container = (XNameContainer)OEnv.obj().obtain(XNameContainer.class, this.xGetMSFactory().createInstance("com.sun.star.drawing.BitmapTable"));
        container.insertByName(bitmapURL, (Object)bitmapURL);
        ODrawDoc.BitmapShape shape = new ODrawDoc.BitmapShape(this, area, true, bitmapURL);
        XDrawPageSupplier supplier = (XDrawPageSupplier)OEnv.obj().obtain(XDrawPageSupplier.class, sheet.xGetXSheet());
        XDrawPage page = supplier.getDrawPage();
        page.add(shape.xGetXShape());
        container.removeByName(bitmapURL);
    }

    public Collection<String> chartNames() throws com.sun.star.uno.Exception {
        LinkedList<String> names = new LinkedList<String>();
        ArrayList<Sheet> sheets = this.sheets();
        for (Sheet sheet : sheets) {
            String[] namesForSheet;
            XTableChartsSupplier supplier = (XTableChartsSupplier)OEnv.obj().obtain(XTableChartsSupplier.class, sheet.xGetXSheet());
            XTableCharts xCharts = supplier.getCharts();
            XNameAccess access = (XNameAccess)OEnv.obj().obtain(XNameAccess.class, xCharts);
            String[] stringArray = namesForSheet = access.getElementNames();
            int n = namesForSheet.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                names.add(name);
                ++n2;
            }
        }
        return names;
    }

    public String writeOds(String url) throws com.sun.star.uno.Exception {
        return this.write(url, OFileFilter.ODS);
    }

    public void writeCsv(String url) throws com.sun.star.uno.Exception {
        this.write(url, OFileFilter.CSV);
    }

    public XSpreadsheetDocument xGetXDoc() {
        return this.iXDoc;
    }

    @Override
    protected void initPropObj() throws com.sun.star.uno.Exception {
        this.setXObj((XInterface)this.iXDoc);
    }

    private void setupSheets() throws com.sun.star.uno.Exception {
        this.iSheetsByNum.clear();
        this.iSheetsByName.clear();
        XIndexAccess access = (XIndexAccess)OEnv.obj().obtain(XIndexAccess.class, this.iXDoc.getSheets());
        short i = 0;
        while (i < access.getCount()) {
            XSpreadsheet xSheet = (XSpreadsheet)OEnv.obj().obtain(XSpreadsheet.class, access.getByIndex((int)i));
            Sheet sheet = new Sheet(this, xSheet, i);
            this.iSheetsByNum.put(i, sheet);
            this.iSheetsByName.put(sheet.name(), sheet);
            i = (short)(i + 1);
        }
    }

    @Override
    protected void logDetails() throws com.sun.star.uno.Exception {
        String msg = "Sheet 0 range in use: " + this.sheet((short)0).rangeInUse().absoluteAddrRange();
        OEnv.obj().log(msg, false);
    }

    public class Sheet {
        private OCalcDoc iDoc = null;
        private XSpreadsheet iXSheet = null;
        private short iNum = (short)-1;

        public short number() {
            return this.iNum;
        }

        public String name() throws com.sun.star.uno.Exception {
            XNamed xNamed = (XNamed)OEnv.obj().obtain(XNamed.class, this.iXSheet);
            return xNamed.getName();
        }

        public CellRange columnRange(int colNum) throws com.sun.star.uno.Exception {
            XColumnRowRange range = (XColumnRowRange)OEnv.obj().obtain(XColumnRowRange.class, this.xGetXSheet());
            XTableColumns cols = range.getColumns();
            XIndexAccess con = (XIndexAccess)OEnv.obj().obtain(XIndexAccess.class, cols);
            XSheetCellRange cRange = (XSheetCellRange)OEnv.obj().obtain(XSheetCellRange.class, con.getByIndex(colNum));
            return new CellRange((XCellRange)cRange);
        }

        public CellRange rowRange(int rowNum) throws com.sun.star.uno.Exception {
            XColumnRowRange range = (XColumnRowRange)OEnv.obj().obtain(XColumnRowRange.class, this.xGetXSheet());
            XTableRows rows = range.getRows();
            XIndexAccess con = (XIndexAccess)OEnv.obj().obtain(XIndexAccess.class, rows);
            XCellRange cRange = (XCellRange)OEnv.obj().obtain(XCellRange.class, con.getByIndex(rowNum));
            return new CellRange(cRange);
        }

        public CellRange areaRange(int topLeftCol, int topLeftRow, int botRightCol, int botRightRow) throws com.sun.star.uno.Exception {
            XCellRange cRange = this.iXSheet.getCellRangeByPosition(topLeftCol, topLeftRow, botRightCol, botRightRow);
            return new CellRange(cRange);
        }

        public CellRange areaRange(String address) throws com.sun.star.uno.Exception {
            XCellRange cRange = this.iXSheet.getCellRangeByName(address);
            return new CellRange(cRange);
        }

        public OTable.Cell cell(int colNum, int rowNum) throws com.sun.star.uno.Exception {
            CellRange range = this.areaRange(colNum, rowNum, colNum, rowNum);
            OTable.Cell cell = range.cellByPosition(0, 0);
            return cell;
        }

        public OTable.Cell cell(String cellAddr) throws com.sun.star.uno.Exception {
            String addr = String.valueOf(cellAddr) + ":" + cellAddr;
            CellRange range = this.areaRange(addr);
            return range.cellByPosition(0, 0);
        }

        public CellRange rangeInUse() throws com.sun.star.uno.Exception {
            XSheetCellCursor cursor = this.iXSheet.createCursor();
            XUsedAreaCursor areaCursor = (XUsedAreaCursor)OEnv.obj().obtain(XUsedAreaCursor.class, cursor);
            areaCursor.gotoStartOfUsedArea(false);
            areaCursor.gotoEndOfUsedArea(true);
            XCellRange usedRange = (XCellRange)OEnv.obj().obtain(XCellRange.class, areaCursor);
            return new CellRange(usedRange);
        }

        public void setName(String name) throws com.sun.star.uno.Exception {
            XNamed xNamed = (XNamed)OEnv.obj().obtain(XNamed.class, this.iXSheet);
            xNamed.setName(name);
            OCalcDoc.this.setupSheets();
        }

        public void insertRowsBelow(int rowNum, int numRows) throws com.sun.star.uno.Exception {
            XColumnRowRange range = (XColumnRowRange)OEnv.obj().obtain(XColumnRowRange.class, this.xGetXSheet());
            XTableRows rows = range.getRows();
            rows.insertByIndex(rowNum, numRows);
        }

        public void deleteRows(int rowNum, int numRows) throws com.sun.star.uno.Exception {
            XColumnRowRange range = (XColumnRowRange)OEnv.obj().obtain(XColumnRowRange.class, this.xGetXSheet());
            XTableRows rows = range.getRows();
            rows.removeByIndex(rowNum, numRows);
        }

        public void insertColumnsRight(int colNum, int numCols) throws com.sun.star.uno.Exception {
            XColumnRowRange range = (XColumnRowRange)OEnv.obj().obtain(XColumnRowRange.class, this.xGetXSheet());
            XTableColumns cols = range.getColumns();
            cols.insertByIndex(colNum, numCols);
        }

        public void deleteColumns(int colNum, int numCols) throws com.sun.star.uno.Exception {
            XColumnRowRange range = (XColumnRowRange)OEnv.obj().obtain(XColumnRowRange.class, this.xGetXSheet());
            XTableColumns cols = range.getColumns();
            cols.removeByIndex(colNum, numCols);
        }

        public void mergeRowCells(int rowNum, int leftColNum, int rightColNum) throws com.sun.star.uno.Exception {
            CellRange range = this.areaRange(leftColNum, rowNum, rightColNum, rowNum);
            XMergeable mergeable = (XMergeable)OEnv.obj().obtain(XMergeable.class, range.getXRange());
            mergeable.merge(true);
        }

        public void protect(String password) throws com.sun.star.uno.Exception {
            XProtectable protect = (XProtectable)OEnv.obj().obtain(XProtectable.class, this.xGetXSheet());
            protect.protect(password);
        }

        public void remove() throws com.sun.star.uno.Exception {
            XNameContainer container = (XNameContainer)OEnv.obj().obtain(XNameContainer.class, OCalcDoc.this.iXDoc.getSheets());
            container.removeByName(this.name());
            OCalcDoc.this.setupSheets();
        }

        public XSpreadsheet xGetXSheet() {
            return this.iXSheet;
        }

        protected Sheet(OCalcDoc doc, XSpreadsheet sheet, short num) {
            this.iDoc = doc;
            this.iXSheet = sheet;
            this.iNum = num;
        }

        protected CellRangeAddress rangeAddress(CellRange range) throws com.sun.star.uno.Exception {
            CellRangeAddress addr = range.rangeAddress();
            addr.Sheet = this.iNum;
            return addr;
        }

        public class CellRange
        extends OEnumPropObj {
            private XCellRange iXRange = null;

            public int numCols() throws com.sun.star.uno.Exception {
                CellRangeAddress addr = this.rangeAddress();
                return addr.EndColumn - addr.StartColumn + 1;
            }

            public int numRows() throws com.sun.star.uno.Exception {
                CellRangeAddress addr = this.rangeAddress();
                return addr.EndRow - addr.StartRow + 1;
            }

            public String absoluteAddrRange() throws com.sun.star.uno.Exception {
                String range = (String)OUtil.prop(this.iXRange, "AbsoluteName");
                int index = range.indexOf(46);
                return range.substring(index + 1);
            }

            public OTable.Cell cellByPosition(int col, int row) throws com.sun.star.uno.Exception {
                XCell xCell = this.iXRange.getCellByPosition(col, row);
                return new OTable.Cell(xCell);
            }

            public OTable.Cell[][] cells() throws com.sun.star.uno.Exception {
                OTable.Cell[][] cells = new OTable.Cell[this.numRows()][this.numCols()];
                int row = 0;
                while (row < this.numRows()) {
                    int col = 0;
                    while (col < this.numCols()) {
                        XCell xCell = this.iXRange.getCellByPosition(col, row);
                        cells[row][col] = new OTable.Cell(xCell);
                        ++col;
                    }
                    ++row;
                }
                return cells;
            }

            public CellRange subRangeByPosition(int left, int top, int right, int bottom) throws com.sun.star.uno.Exception {
                XCellRange cRange = this.iXRange.getCellRangeByPosition(left, top, right, bottom);
                return new CellRange(cRange);
            }

            public Object[][] cellContents() throws com.sun.star.uno.Exception {
                Object[][] objects = null;
                try {
                    XCellRangeData rangeData = (XCellRangeData)OEnv.obj().obtain(XCellRangeData.class, this.iXRange);
                    Object[][] data = rangeData.getDataArray();
                    objects = new Object[data.length][data[0].length];
                    int i = 0;
                    while (i < objects.length) {
                        int j = 0;
                        while (j < objects[0].length) {
                            objects[i][j] = data[i][j];
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (com.sun.star.uno.Exception xcp) {
                    UserMsg msg = OUserMsgs.msg("data-mismatch");
                    OEnv.throwError(msg.format());
                }
                return objects;
            }

            public void logCellContents() throws com.sun.star.uno.Exception {
                Object[][] contents = this.cellContents();
                LinkedList<String> strs = new LinkedList<String>();
                int i = 0;
                while (i < contents.length) {
                    int j = 0;
                    while (j < contents[0].length) {
                        String str = "[" + i + "][" + j + "] = " + contents[i][j].toString();
                        strs.add(str);
                        ++j;
                    }
                    ++i;
                }
                OEnv.obj().log(strs, "cell range contents");
            }

            public void putFormat(OTable.CellNumberFormat format) throws com.sun.star.uno.Exception {
                XNumberFormatsSupplier supplier = (XNumberFormatsSupplier)OEnv.obj().obtain(XNumberFormatsSupplier.class, Sheet.this.iDoc.xGetXDoc());
                XNumberFormats formats = supplier.getNumberFormats();
                XNumberFormatTypes types = (XNumberFormatTypes)OEnv.obj().obtain(XNumberFormatTypes.class, formats);
                Locale locale = new Locale();
                int typeKey = 0;
                if (format == OTable.CellNumberFormat.DATE) {
                    typeKey = types.getStandardFormat((short)2, locale);
                } else if (format == OTable.CellNumberFormat.TIME) {
                    typeKey = types.getStandardFormat((short)4, locale);
                } else if (format == OTable.CellNumberFormat.CURRENCY) {
                    typeKey = types.getStandardFormat((short)8, locale);
                } else if (format == OTable.CellNumberFormat.NUMBER) {
                    typeKey = types.getStandardFormat((short)16, locale);
                } else if (format == OTable.CellNumberFormat.SCIENTIFIC) {
                    typeKey = types.getStandardFormat((short)32, locale);
                } else if (format == OTable.CellNumberFormat.FRACTION) {
                    typeKey = types.getStandardFormat((short)64, locale);
                } else if (format == OTable.CellNumberFormat.PERCENT) {
                    typeKey = types.getStandardFormat((short)128, locale);
                } else if (format == OTable.CellNumberFormat.TEXT) {
                    typeKey = types.getStandardFormat((short)256, locale);
                } else if (format == OTable.CellNumberFormat.DATETIME) {
                    typeKey = types.getStandardFormat((short)6, locale);
                } else if (format == OTable.CellNumberFormat.LOGICAL) {
                    typeKey = types.getStandardFormat((short)1024, locale);
                }
                this.setProp(OProps.Cell.NumberFormat, (Object)new Integer(typeKey));
            }

            public void merge() throws com.sun.star.uno.Exception {
                XMergeable mergeable = (XMergeable)OEnv.obj().obtain(XMergeable.class, this.iXRange);
                mergeable.merge(true);
            }

            public void putCellText(String[][] values) throws com.sun.star.uno.Exception {
                try {
                    XCellRangeData rangeData = (XCellRangeData)OEnv.obj().obtain(XCellRangeData.class, this.iXRange);
                    rangeData.setDataArray((Object[][])values);
                }
                catch (com.sun.star.uno.Exception xcp) {
                    UserMsg msg = OUserMsgs.msg("data-mismatch");
                    OEnv.throwError(msg.format());
                }
            }

            public void putCellNumbers(Double[][] values) throws com.sun.star.uno.Exception {
                try {
                    XCellRangeData rangeData = (XCellRangeData)OEnv.obj().obtain(XCellRangeData.class, this.iXRange);
                    rangeData.setDataArray((Object[][])values);
                }
                catch (com.sun.star.uno.Exception xcp) {
                    UserMsg msg = OUserMsgs.msg("data-mismatch");
                    OEnv.throwError(msg.format());
                }
            }

            public void putStyle(OStyle style) throws com.sun.star.uno.Exception {
                XPropertySet propSet = (XPropertySet)OEnv.obj().obtain(XPropertySet.class, this.iXRange);
                propSet.setPropertyValue(OProps.Cell.CellStyle.toString(), (Object)style.name());
            }

            public void applyStyle(ORootDoc doc, OStyle.Family family, String name) throws com.sun.star.uno.Exception {
                OStyle style = doc.style(family, name);
                this.putStyle(style);
            }

            public XCellRange getXRange() {
                return this.iXRange;
            }

            @Override
            protected void initPropObj() throws com.sun.star.uno.Exception {
                this.setXObj((XInterface)this.iXRange);
            }

            protected CellRange(XCellRange range) throws com.sun.star.uno.Exception {
                this.iXRange = range;
                this.setXObj((XInterface)range);
            }

            protected Sheet sheet() {
                return Sheet.this;
            }

            protected CellRangeAddress rangeAddress() throws com.sun.star.uno.Exception {
                CellRangeAddress addr = new CellRangeAddress();
                addr.Sheet = this.sheet().number();
                String rangeName = this.absoluteAddrRange().replace("$", "");
                int index = rangeName.indexOf(58);
                String topLeftCell = rangeName.substring(0, index);
                int[] colAndRow = OTable.colRowFromAddr(topLeftCell);
                addr.StartColumn = colAndRow[0];
                addr.StartRow = colAndRow[1];
                String botRightCell = rangeName.substring(index + 1);
                colAndRow = OTable.colRowFromAddr(botRightCell);
                addr.EndColumn = colAndRow[0];
                addr.EndRow = colAndRow[1];
                return addr;
            }
        }

        public class Iterator {
            private CellRange iRange = null;
            private CellRangeAddress iAddress = null;
            private int iRow = 0;
            private int iCol = -1;
            private boolean iHasNext = false;

            public Iterator(CellRange range) throws com.sun.star.uno.Exception {
                this.iRange = range;
                this.iAddress = range.rangeAddress();
            }

            public boolean hasNext() throws com.sun.star.uno.Exception {
                this.iHasNext = false;
                ++this.iCol;
                if (this.iCol >= this.iRange.numCols()) {
                    this.iCol = 0;
                    ++this.iRow;
                }
                this.iHasNext = this.iRow < this.iRange.numRows();
                return this.iHasNext;
            }

            public OTable.Cell next() throws com.sun.star.uno.Exception {
                OTable.Cell cell = null;
                if (this.iHasNext) {
                    cell = this.iRange.cellByPosition(this.iCol, this.iRow);
                }
                return cell;
            }
        }
    }
}

